<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use App\Models\Emailtemplate;
use App\Models\Bibleverse;

class ChurchesController extends Controller
{

    public function save(Request $request)
    {

        $new_request = new Request;
        // $new_request['user_id'] = $request->user()->id;
        $new_request['church_name'] = $request->church_name;
        $new_request['keyword'] = $request->keyword;
        $response_from_parent = parent::save($new_request);
        $this->FnCloneDefaultEmailTemplates($response_from_parent['results']['id']);
        $this->FnCloneDefaultBibleVerses($response_from_parent['results']['id']);
        return $response_from_parent;
    }

    public function FnCloneDefaultEmailTemplates($request_id)
    {
        $notInIds = [8, 2];
        $default_email_templates = Emailtemplate::where('is_default', 0)->whereNotIn('id', $notInIds)->get();
        foreach ($default_email_templates as $single_template) :
            DB::table('emailtemplates')->insert(
                ['name' => $single_template->name, 'mail_from' =>  $single_template->mail_from, 'mail_subject' => $single_template->mail_subject, 'mail_body' => $single_template->mail_body, 'sms_subject' => $single_template->sms_subject, 'sms_body' => $single_template->sms_body, 'is_default' => 1, 'church_id' => $request_id]
            );
        endforeach;
        return 1;
    }

    public function FnCloneDefaultBibleVerses($request_id)
    {
        $bibleverses = Bibleverse::where('is_default', 0)->where('church_id', 0)->get();
        foreach ($bibleverses as $bibleverse) :
            DB::table('bibleverses')->insert(
                ['verse' => $bibleverse->verse, 'created_at' => now(), 'is_default' => 1, 'church_id' => $request_id]
            );
        endforeach;
        return 1;
    }

    public function delete(Request $request)
    {
        $response = parent::delete($request);
        if (count($request->ids) > 0) :
            DB::table('emailtemplates')->where('is_default', 1)->whereIn('church_id', $request->ids)->delete();
            DB::table('bibleverses')->where('is_default', 1)->whereIn('church_id', $request->ids)->delete();
        endif;
        return $response;
    }
}
