<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\TwilioMsgReceive;
use Carbon\Carbon;
use App\Models\Church;

class Controller extends BaseController
{

    use AuthorizesRequests,
        DispatchesJobs,
        ValidatesRequests;

    public $model;
    public $resource;

    /**
     * To get all resources.
     */
    public function __construct(Request $request)
    {
        $this->model = $request->ctrl;
        //$this->resource = $this->getModel();
    }

    public function getList(Request $request)
    {
        //return $this->getModel();
        return array('results' => $this->getModel()->getList($request), 'fields' => $this->getFields());
    }

    public function createView()
    {
        return array('fields' => $this->getFields());
    }

    /**
     * For creating a new resource.
     */
    public function save(Request $request)
    {
        $resource = $this->getModel();
        $result = $resource->publish($request);
        if ($resource->model == 'keyword') {
            return $result;
        } else {
            return array('results' => $result);
        }
    }

    /**
     * To get the specific resource.
     * @param  $request
     */
    public function view(Request $request)
    {
        $result = $this->getModel()->view($request);
        $fields = $this->getFields();
        foreach ($fields as $key => $field) {
            if (isset($result['result']->$key) && $field['type'] === 'autocomplete' && array_key_exists('related_table', $field) && array_key_exists('multiple', $field) && !$field['multiple']) {
                $data = $result['result']->$key;
                $query = DB::table($field['related_table'])->find($data);
                if ($query) {
                    $column = $field['searchable'];
                    array_push($fields[$key]['options'], array('index' => $query->id, 'value' => $query->$column));
                }
            }
        }
        return array('results' => $result, 'fields' => $fields);
    }

    /**
     * Update the specific resource in storage.
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     */
    public function update(Request $request, $id)
    {
        return $resource = $this->getModel()->revise($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $resource_model = $this->getModel();
        $result = $resource_model->remove($request);
        return array('results' => $result);
    }

    public function deletePermanently(Request $request)
    {
        $resource_model = $this->getModel();
        $result = $resource_model->deletePermanently($request);
        return array('results' => $result);
    }

    /**
     * Restore the specified resource from trash.
     *
     * @param  array  $ids
     * @return \Illuminate\Http\Response
     */
    public function restore(Request $request)
    {
        $resource_model = $this->getModel();
        $result = $resource_model->revert($request);
        return array('results' => $result);
    }

    /**
     * Fetch dropdown options for all model for autocomplete functionality
     */
    public function fetchDropdownOptions(Request $request)
    {
        $resource_model = $this->getModel();
        $result = $resource_model->fetchDropdownOptions($request);
        return array('results' => $result);
    }

    public function getModelNamespace()
    {
        $model_str = 'App\Models\\' . ucfirst(Str::singular($this->model));
        return $model_str;
    }

    public function getFields()
    {
        $resource = $this->getModel();
        return $resource->fields_array;
    }

    public function getModel($id = null)
    {
        $model_str = $this->getModelNamespace();
        if ($id) {
            $connection_object = $model_str::find($id);
            $msg = 'existing';
        } else {
            $connection_object = new $model_str();
            $msg = 'new';
        }
        return $connection_object;
    }

    public function getBibleVerse($church_id)
    {
        $bibleverses = DB::table('bibleverses')->where('church_id', $church_id)->where('is_default', 1)->inRandomOrder()->first();
        // $bibleverses = DB::table('bibleverses')->inRandomOrder()->first();
        return $bibleverses->verse;
    }

    public function FnGetOrCreateRequester($msg_received_from_phone_no)
    {
        $response = array();
        $email = $msg_received_from_phone_no . '@requester.req';

        $email = str_replace('+1', '', $email);
        $email = str_replace('+91', '', $email);
        $email = str_replace('+', '', $email);
        $requesterDetails = User::where('email', $email)->orderBy('id', 'Desc')->get()->toArray(); // check user by phone no       
        if (count($requesterDetails) == 0) : // no existing record create requestor's record
            // $email = trim($msg_received_from_phone_no, "+") . '@requester.req';
            $identity_key = md5($msg_received_from_phone_no . time());
            $requesterDetails = User::create(['first_name' => 'Prayee', 'last_name' => 'User', 'email' => $email, 'phone' => $msg_received_from_phone_no, 'avatar' => 'default_user.png', 'identity_key' => $identity_key]);
            $response = array('id' => $requesterDetails->id, 'phone' => $requesterDetails->phone, 'identity_key' => $requesterDetails->identity_key, 'last_connected_church_id' => $requesterDetails->last_connected_church_id);
        else :
            $response = array('id' => $requesterDetails[0]['id'], 'phone' => $requesterDetails[0]['phone'], 'identity_key' => $requesterDetails[0]['identity_key'], 'last_connected_church_id' => $requesterDetails[0]['last_connected_church_id']);
        endif;
        return $response;
    }

    public function FnSaveTwilioMsg($user_id, $company_id, $msg_content, $msg_id, $adjective = '', $now = '', $expiry = '')
    {
        $modelInbound = new \App\Models\TwilioMsgReceive;
        $modelInbound->received_from = $user_id;
        $modelInbound->company_id = $company_id;
        $modelInbound->msg_content = $msg_content;
        $modelInbound->msg_sid = $msg_id;
        if (trim($adjective) != '') :
            $modelInbound->adjective = $adjective;
        endif;
        if (!empty($now) && !empty($expiry)) :
            $modelInbound->created_at = $now;
            $modelInbound->expired_at = $expiry;
        endif;
        $modelInbound->save();
        return 1;
    }

    public function webform(Request $request)
    {
        $From = $request->From;
        $To = $request->toNumber;
        $Body = $request->bodyMsg;
        $SmsSid = $request->SmsSid;
        $keyword = $request->keyword;

        if (empty($From) || empty($To) || empty($Body) || empty($SmsSid)) {
            return json_encode(['status' => 200, 'msg' => "All fields are mandatory"]);
        }


        $churchDetails = \App\Models\Church::where('keyword', $request->keyword)->get()->toArray();
        $requesterArr = $this->FnGetOrCreateRequester($From);  // get requestor details

        $chatCreationAt = date('Y-m-d H:i:s');
        $chatExpiryAt = date('Y-m-d H:i:s', strtotime('+24 hours', strtotime($chatCreationAt)));

        $latestKeywordDetails = TwilioMsgReceive::where('received_from', $requesterArr['id'])->where('expired_at', '>=', date('Y-m-d H:i:s'))->whereNull('adjective')->orderBy('id', 'Desc')->get()->toArray();

        if (count($latestKeywordDetails) >= 1) :
            $chatCreationAt = $latestKeywordDetails[0]['created_at'];
            $chatExpiryAt = $latestKeywordDetails[0]['expired_at'];
        endif;

        if (count($churchDetails) != 0) : // received message is a keyword 
            $church_id = $churchDetails[0]['id'];
            if (count($latestKeywordDetails) >= 1) :
                return json_encode(['status' => 200, 'msg' => 'Already a chat present']);
            endif;

            $notification = \App\Models\Emailtemplate::where('name', 'organisation_connected_success')->where('church_id', $church_id)->get()->toArray();
            $this->sendSMS($requesterArr['phone'], $notification[0]['sms_subject'], $notification[0]['sms_body'], $church_id);
            $this->FnSaveTwilioMsg($requesterArr['id'], $churchDetails[0]['id'], $request->keyword, $SmsSid, "", $chatCreationAt, $chatExpiryAt); // inbound message save

            // echo $church_id;

            DB::table('users')->where('id', $requesterArr['id'])->update(array('last_connected_church_id' => $church_id));

        endif;

        $new_request = new Request;
        $new_request['From'] = $From;
        $new_request['To'] = $To;
        $new_request['Body'] = $Body;
        $new_request['SmsSid'] = $SmsSid;
        $new_request['webform'] = true;

        return $this->fetchInboundSms($new_request);
    }

    public function fetchInboundSms(Request $request)
    {
        // dd($request);
        $post = $_POST;
        $chat_domain_url = 'https://chat.prayer4.me/chat/';
        $adjective = "";
        $church_id = 0;
        $church_keyword = ($request->webform) ? $request->Body : $post['Body'];
        $from = ($request->webform) ? $request->From : $post['From'];
        $SmsSid = ($request->webform) ? $request->SmsSid : $post['SmsSid'];


        $churchDetails = \App\Models\Church::where('keyword', $church_keyword)->get()->toArray();
        $requesterArr = $this->FnGetOrCreateRequester($from);  // get requestor details
        // dd($requesterArr);
        $last_message_expired = 0;
        $chatCreationAt = date('Y-m-d H:i:s');
        $chatExpiryAt = date('Y-m-d H:i:s', strtotime('+24 hours', strtotime($chatCreationAt)));

        $latestKeywordDetails = TwilioMsgReceive::where('received_from', $requesterArr['id'])->where('expired_at', '>=', date('Y-m-d H:i:s'))->whereNull('adjective')->orderBy('id', 'Desc')->get()->toArray();

        if (count($latestKeywordDetails) >= 1) :
            $chatCreationAt = $latestKeywordDetails[0]['created_at'];
            $chatExpiryAt = $latestKeywordDetails[0]['expired_at'];
        else :
            $last_message_expired = 1;
            DB::table('users')->where('id', $requesterArr['id'])->update(['last_connected_church_id' => 0]);
        endif;

        if (count($churchDetails) != 0) : // received message is a keyword 
            $church_id = $churchDetails[0]['id'];

            // if the last message is a keyword within last 24 hours let him know that existing chat is there.
            if (count($latestKeywordDetails) >= 1) :
                return json_encode(['status' => 200, 'msg' => 'Already a chat present']);
            endif;


            // if last chat expired then save the inbound message and send organisation connected message.

            $notification = \App\Models\Emailtemplate::where('name', 'organisation_connected_success')->where('church_id', $church_id)->get()->toArray();
            $this->sendSMS($requesterArr['phone'], $notification[0]['sms_subject'], $notification[0]['sms_body'], $church_id);
            $this->FnSaveTwilioMsg($requesterArr['id'], $churchDetails[0]['id'], $post['Body'], $post['SmsSid'], $adjective, $chatCreationAt, $chatExpiryAt); // inbound message save

            DB::table('users')->where('id', $requesterArr['id'])->update(array('last_connected_church_id' => $church_id));
            return json_encode(['status' => 200, 'msg' => 'Organisation connected Successfully.']);
        else : // received message is not a church keyword

            $church_id = ($last_message_expired) ? 0 : $requesterArr['last_connected_church_id'];

            if ($church_id < 1) : // if the keyword send isn't a church keyword.
                $failedNotification = \App\Models\Emailtemplate::where('name', 'organisation_connection_faliure')->get()->toArray();
                $this->sendSMS($requesterArr['phone'], $failedNotification[0]['sms_subject'], $failedNotification[0]['sms_body'], $church_id);
                return json_encode(['status' => 200, 'msg' => 'Organisation not found with the above keyword.']);
            endif;





            $latestRgDetails = \App\Models\RequesterGroup::where('requester_id', $requesterArr['id'])->where('company_id', $church_id)->where('expired_at', '>=', date('Y-m-d H:i:s'))->orderBy('id', 'Desc')->get()->toArray();
            $adjective = 'chat message from requestor';
            if (strtolower($church_keyword) == 'stop') { // expire the chat groups if the keyword matches stop
                $requestor_group_id = $latestRgDetails[0]['id'];
                $latestKeywordDetailsId = $latestKeywordDetails[0]['id'];
                if ($requestor_group_id > 0 && $latestKeywordDetailsId > 0) {

                    // dd($latestKeywordDetails);

                    $expiration_date = date('Y-m-d H:i:s', strtotime('-24 hours', strtotime($chatCreationAt)));
                    DB::table('requester_groups')->where('id', $requestor_group_id)->update(['expired_at' => $expiration_date]);
                    DB::table('twilio_msg_receives')->where('id', $latestKeywordDetailsId)->update(['expired_at' => $expiration_date]);
                    DB::table('users')->where('id', $requesterArr['id'])->update(['last_connected_church_id' => 0]);
                    $stopCommentNotification = \App\Models\Emailtemplate::where('name', 'stop_chat_from_requester')->where('church_id', $church_id)->get()->toArray();
                    $this->sendSMS($requesterArr['phone'], $stopCommentNotification[0]['sms_subject'], $stopCommentNotification[0]['sms_body'], $church_id);
                    $this->FnSaveTwilioMsg($requesterArr['id'], $church_id, strtolower($church_keyword), $post['SmsSid'], $adjective, date('Y-m-d H:i:s'), ""); // inbound message save
                    return json_encode(['status' => 200, 'msg' => 'Existing chat has been deactivated successfully.']);
                }

                dd($latestKeywordDetails);
            }



            $requestorGroupId = "";



            $this->FnSaveTwilioMsg($requesterArr['id'], $church_id, $church_keyword, $SmsSid, $adjective, date('Y-m-d H:i:s'), ''); // inbound message save
            $first_message = 1;
            if (count($latestRgDetails) == 0) : // received first message from requestor

                // prayer submission success message to requester start
                $notification = \App\Models\Emailtemplate::where('name', 'thank_you_for_submitting_prayer')->where('church_id', $church_id)->get()->toArray();
                $this->sendSMS($requesterArr['phone'], $notification[0]['sms_subject'], $notification[0]['sms_body'], $church_id);

                // bible verse sms start 
                sleep(5);
                $ls_smsContent = $this->getBibleVerse($church_id);
                $this->sendSMS($requesterArr['phone'], 'Verse for you!', $ls_smsContent, $church_id);

                // chat link creation start  
                sleep(20);
                $requestorGroupId = strtoupper($requesterArr['id'] . ': ' . $church_keyword);
                $requestorGroup = new \App\Models\RequesterGroup();
                $requestorGroup->requester_id = $requesterArr['id'];
                $requestorGroup->group_id = $requestorGroupId;
                $requestorGroup->company_id = $church_id;
                $requestorGroup->is_chat_started_by_responder = 'N';
                $requestorGroup->created_at = $chatCreationAt;
                $requestorGroup->expired_at = $chatExpiryAt;
                $requestorGroup->save();

                $requestorGroupId = $requestorGroup->id;


            else :
                $requestorGroupId = $latestRgDetails[0]['id'];
                $first_message = 0;
            endif;

            $responders = DB::table('users')
                ->Join(
                    'model_has_roles',
                    'users.id',
                    '=',
                    'model_has_roles.model_id'
                )
                ->Join('church_user', 'church_user.user_id', '=', 'users.id')
                ->where('church_user.church_id', $church_id)
                ->where('users.notification', 1)
                ->whereNull('users.deleted_at')
                ->where('users.active', 1)
                ->whereIn('model_has_roles.role_id', [18, 19])
                ->get();
            $requestor_code = ($first_message) ? "chat_link_send_to_responder" : "new_comment_from_requestor";
            $responderNotification = \App\Models\Emailtemplate::where('name', $requestor_code)->where('church_id', $church_id)->get()->toArray();
            $chatlinks = [];
            foreach ($responders as $singleResponder) {

                $li_userIdentityKey = $singleResponder->identity_key;
                $data['chatlink'] = $chat_domain_url . $church_id . '/' . $li_userIdentityKey;
                $chatlinks[] = $data['chatlink'];
                $ls_smsContent = $this->generateDynamicEmailContent($responderNotification[0]['sms_body'], $data);

                $this->sendSMS($singleResponder->phone, $responderNotification[0]['sms_subject'], $ls_smsContent, $church_id);
            }

            // add the prayer as first message in the chat start     

            $modelChat = new \App\Models\UsersChatDetail();
            $modelChat->msg_from_id = $requesterArr['id'];
            $modelChat->group_id = $requestorGroupId;
            $modelChat->msg_body = $church_keyword;
            $modelChat->created_at = date('Y-m-d H:i:s');
            $modelChat->save();

            return json_encode(['status' => 200, 'msg' => 'Chat links send to prayer team member successully.', 'chatlinks' => $chatlinks]);

        endif;
    }

    public function firstResponseNotificationToRequester()
    {
        $post = $_POST;
        sleep(rand(1, 5));
        sleep(rand(1, 5));
        if (collect(\DB::select('SELECT is_notification_sent_to_requester FROM requester_groups WHERE group_id = "' . $post['group_id'] . '"'))->first()->is_notification_sent_to_requester == 'N') {
            DB::table('requester_groups')->where('group_id', $post['group_id'])->update(['is_notification_sent_to_requester' => 'Y']);
            $chat_domain_url = 'https://chat.prayer4.me/';
            $la_getRequester = \App\Models\User::where('id', $post['requester_id'])
                ->select('identity_key', 'first_name', 'phone', 'email')
                ->get()
                ->first()
                ->toArray();    // fetch connect requester details   
            $li_userIdentityKey = $la_getRequester['identity_key'];
            $data['chatlink'] = $chat_domain_url . $li_userIdentityKey; // creation of the chat link 
            $data['groupid'] = $post['group_id'];
            $organization_id = $this->FnCheckOrGetOrganisationAdmin($post['company_id']);
            $la_getNotification = \App\Models\Emailtemplate::where('name', 'first_responder_submit_reply')->where('user_id', $organization_id)->get()->toArray();
            $ls_smsContent = $this->generateDynamicEmailContent($la_getNotification[0]['sms_body'], $data); // sms template   
            $this->sendSMS($la_getRequester['phone'], $la_getNotification[0]['sms_subject'], $ls_smsContent, $post['company_id']); //sms send   
        }
    }

    public function sendSMS($li_userPhone, $subject, $message, $company_id)
    {

        $results = \App\Models\Setting::whereIn('field_name', ['twilio-account-sid', 'twilio-auth-token', 'twilio-mobile-number'])->get()->toArray(); // fetch twilio keys from setting table 
        $ls_twilioAccountSid = $ls_twilioAuthToken = $ls_twilioMobileNumber = '';
        foreach ($results as $value) {
            if ($value['field_name'] == 'twilio-account-sid') {
                $ls_twilioAccountSid = $value['field_value'];
            }
            if ($value['field_name'] == 'twilio-auth-token') {
                $ls_twilioAuthToken = $value['field_value'];
            }
            if ($value['field_name'] == 'twilio-mobile-number') {
                $ls_twilioMobileNumber = $value['field_value'];
            }
        }

        // message send status recorded in notification log start
        // echo $li_userPhone;
        $model = new \App\Models\NotificationLog;
        $model->notification_type = 'S';
        $model->company_id = $company_id;
        $model->to = $li_userPhone;
        $model->from = $ls_twilioMobileNumber;
        $model->subject = $subject;
        $model->body = $message;
        $model->ip = $_SERVER['REMOTE_ADDR'];
        $model->save();
        // message send status recorded in notification log end


        // call twilio api and send the message to phone number start
        $url = "https://api.twilio.com/2010-04-01/Accounts/$ls_twilioAccountSid/Messages.json";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "Body=$message&From=$ls_twilioMobileNumber&To=$li_userPhone");
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 300);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/x-www-form-urlencoded'
            // 'Content-Type: application/json'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $ls_twilioAccountSid . ':' . $ls_twilioAuthToken);
        $output = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        // call twilio api and send the message to phone number end
    }

    public function generateDynamicEmailContent($ls_text, $result = array())
    {
        foreach ($result as $key => $val) {
            $ls_customizedVarName = "[" . $key . "]";
            $ls_text = str_replace($ls_customizedVarName, $val, $ls_text);
        }
        return $ls_text;
    }

    public function testAction()
    {
        //        $la_getUser = DB::table('users')->select('id')->where('id', 81)->orWhere('company_id', 81)->get()->toArray();
        $la_getUser = collect(\DB::select('SELECT is_notification_sent_to_requester FROM requester_groups WHERE group_id = "Lal_ORGANISATION-24" '))->first()->is_notification_sent_to_requester;
        print_r($la_getUser);
        DB::table('requester_groups')->where('group_id', 'Lal_ORGANISATION-24')->update(['is_notification_sent_to_requester' => 'Y']);
        die;
    }
}
