<?php

namespace App\Http\Helpers;
use Carbon\Carbon;
class UploadHelper
{        
    public static function UploadFile( $file, $module, $fileName = NULL )
    {            
        if($file->isValid())
        {
            $fileName = is_null($fileName) ? Carbon::now()->timestamp.$file->getClientOriginalName() : $fileName;
            $destinationPath = self::getDestinationPath($module);
            $file->move($destinationPath, $fileName);
            return $fileName;
        }
        else {
            throw new Exception( "Something is wrong with the file." );
        }
    }

    public static function getDestinationPath($module){
        $path = public_path() . '/uploads/';
        switch($module){
            case 'user': 
                $path.='users/';
            break;
        }
        return $path;
    }
}