<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Bibleverse extends BaseModel
{

    use SoftDeletes;

    protected static $logAttributes = ['verse'];
    protected $fillable = ['verse', 'is_default', 'church_id'];
    public $searchable = ['verse', 'is_default'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'Bibleverse';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'verse' => array(
            'field_name' => 'verse',
            'db_name' => 'verse',
            'type' => 'text',
            'placeholder' => 'Verse body',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        )
    );

    public function getListQuery(Request $request)
    {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)
            ->select(DB::raw($raw_sql));

        switch ($request->user()->roles->first()->id) {
            case 18: // organisational-admin 
                $churchColl =  DB::table('church_user')->where('user_id', $request->user()->id)->get()->pluck('church_id');
                $church_id = count($churchColl) > 0 ? $churchColl['0'] : "";
                $query->where('bibleverses.church_id', '=', $church_id);
                break;
            case 17: // super-admin 
                $query->where('bibleverses.church_id', '=', 0);
                break;
            case 21: // developer 
            default:
        }

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        if ($trash == 'false') {
            $query->whereNull('bibleverses.deleted_at');
        } else {
            $query->whereNotNull('bibleverses.deleted_at');
        }
        $query->orderBy($sort, $sort_order);
        return $query;
    }
}
