<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;

class Changelog extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['type', 'title', 'message', 'active'];
    protected $fillable = ['type', 'title', 'message', 'active'];
    public $searchable = ['type'. 'title', 'message'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'changelog';
    
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'type' => array(
            'field_name' => 'type',
            'db_name' => 'type',
            'type' => 'select',
            'placeholder' => 'Type',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
			'width' => '50',
			'options' => array(
				'Tips' => 'Tips',
				'Feature' => 'Feature',
				'Announcement' => 'Announcement',
				'Enhancement' => 'Enhancement',
			)
		),
		'title' => array(
            'field_name' => 'title',
            'db_name' => 'title',
            'type' => 'textarea',
            'placeholder' => 'Title',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '100'
		),
        'message' => array(
            'field_name' => 'message',
            'db_name' => 'message',
            'type' => 'ckeditor',
            'placeholder' => 'Message',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '100'
		),
        'active' => array(
            'field_name' => 'active',
            'db_name' => 'active',
            'type' => 'switch',
            'placeholder' => 'Active',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => 1,
            'width' => '50'
        ),
    );
}