<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use phpseclib\Crypt\RSA;
use phpseclib\Net\SFTP;
use App\Models\User;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends BaseModel {

    use SoftDeletes;

    protected static $logAttributes = ['name', 'description', 'protocol', 'passphrase', 'host', 'port', 'encryption', 'logon', 'user', 'password', 'file', 'account', 'encryption_key', 'comments', 'field_mapper', 'import_count', 'server_connection', 'deleted'];
    protected $fillable = ['name', 'description', 'protocol', 'host', 'port', 'passphrase', 'encryption', 'logon', 'user', 'password', 'file', 'account', 'encryption_key', 'comments', 'field_mapper', 'import_count', 'server_connection', 'deleted'];
    public $searchable = ['name', 'description', 'protocol', 'host', 'port', 'logon', 'user', 'account', 'encryption_key', 'comments'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'company';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'name' => array(
            'field_name' => 'name',
            'db_name' => 'name',
            'type' => 'text',
            'placeholder' => 'Name',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'protocol' => array(
            'field_name' => 'protocol',
            'db_name' => 'protocol',
            'type' => 'select',
            'options' => array('FTP' => 'FTP', 'SFTP' => 'SFTP', 'Storj' => 'Storj'),
            //'options' => array('FTP', 'SFTP', 'Storj'),
            'placeholder' => 'Protocol',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'host' => array(
            'field_name' => 'host',
            'db_name' => 'host',
            'type' => 'text',
            'placeholder' => 'Host',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'port' => array(
            'field_name' => 'port',
            'db_name' => 'port',
            'type' => 'text',
            'placeholder' => 'Port',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'encryption' => array(
            'field_name' => 'encryption',
            'db_name' => 'encryption',
            'type' => 'select',
            'options' => array('Explicit FTP over TLS if available' => 'Explicit FTP over TLS if available', 'Require Explicit FTP over TLS' => 'Require Explicit FTP over TLS', 'Implicit FTP over TLS' => 'Implicit FTP over TLS', 'Plain FTP' => 'Plain FTP'),
            //'options' => array('Explicit FTP over TLS if available', 'Require Explicit FTP over TLS', 'Implicit FTP over TLS', 'Plain FTP'),
            'placeholder' => 'Encryption',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'logon' => array(
            'field_name' => 'logon',
            'db_name' => 'logon',
            'type' => 'select',
            'options' => array('Anonymous' => 'Anonymous', 'Normal' => 'Normal', 'Account' => 'Account', 'Key File' => 'Key File'),
            'placeholder' => 'Logon',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'user' => array(
            'field_name' => 'user',
            'db_name' => 'user',
            'type' => 'text',
            'placeholder' => 'User',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'password' => array(
            'field_name' => 'password',
            'db_name' => 'password',
            'type' => 'password',
            'placeholder' => 'password',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'passphrase' => array(
            'field_name' => 'passphrase',
            'db_name' => 'passphrase',
            'type' => 'password',
            'placeholder' => 'Passphrase',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'private_key' => array(
            'field_name' => 'private_key',
            'db_name' => 'file',
            'type' => 'textarea',
            'placeholder' => 'Private Key',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'account' => array(
            'field_name' => 'account',
            'db_name' => 'account',
            'type' => 'text',
            'placeholder' => 'account',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'encryption_key' => array(
            'field_name' => 'encryption_key',
            'db_name' => 'encryption_key',
            'type' => 'text',
            'placeholder' => 'Encryption Key',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'comments' => array(
            'field_name' => 'comments',
            'db_name' => 'comments',
            'type' => 'text',
            'placeholder' => 'Comments',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'field_mapper' => array(
            'field_name' => 'field_mapper',
            'db_name' => 'field_mapper',
            'type' => 'fieldmapper',
            'placeholder' => 'Field Mapper',
            'listing' => false,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'width' => '50'
        )
    );

    function __construct() {
        parent::__construct();
        $this->fields_array['field_mapper']['options'] = config('fieldmapper.fields');
    }

    public function getListQuery(Request $request) {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)->select(DB::raw($raw_sql));
        if ($request->user()->company_id != 2) {
            $query->where('id', '<>', 2);
        }

        if ($request->user()->can('list-all-companies')) {
            $query = $query;
        } else if ($request->user()->can('list-group-companies')) {
            $query->where('id', '=', $request->user()->company_id);
        }
        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }
        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $table . '.' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        $query->where('deleted', 0);
        if ($trash == 'false') {
            $query->whereNull('deleted_at');
        } else {
            $query->whereNotNull('deleted_at');
        }
        $query->orderBy($sort, $sort_order);

        return $query;
    }

    public function testConnection(Request $request) {
        $adapter = [];
        if ($request->protocol === 'SFTP') {
            $adapter['logon'] = $request->logon;
            $adapter['host'] = $request->host;
            $adapter['port'] = $request->port;
            $adapter['username'] = $request->user;
            $adapter['password'] = $request->password;
            $adapter['privateKey'] = $request->file;
            $adapter['passphrase'] = $request->passphrase;
            $adapter['root'] = '/';
            $adapter['timeout'] = 30;
            return $this->sftpConnector($adapter);
        }
        if ($request->protocol === 'FTP') {
            $adapter['host'] = $request->host;
            $adapter['port'] = $request->port;
            $adapter['username'] = $request->user;
            $adapter['password'] = $request->password;
            $adapter['root'] = '/';
            $adapter['timeout'] = 30;
            $adapter['ssl'] = true;
            $adapter['passive'] = true;
            return $this->ftpConnector($adapter);
        }
    }

    public function sftpConnector($adapter) {
        try {
            $sftp_login;
            $sftp = new SFTP($adapter['host']);
            if ($adapter['logon'] === 'Key File') {
                $Key = new RSA();
                if ($adapter['passphrase']) {
                    $Key->setPassword($adapter['passphrase']);
                }
                $Key->loadKey($adapter['privateKey']);
                $sftp_login = $sftp->login($adapter['username'], $Key);
            } else {
                $sftp_login = $sftp->login($adapter['username'], $adapter['password']);
            }

            if ($sftp_login) {
                return array('status' => true, 'message' => '');
            } else {
                return array('status' => false, 'message' => 'Connection Failed');
            }
        } catch (Exception $e) {
            return array('status' => false, 'message' => $e->getMessage());
        }
    }

    public function ftpConnector($adapter) {
        try {
            $fp = fopen($adapter['root'], 'r');
            $ftp_server = 'ftps://' . $adapter['host'] . '/';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $ftp_server);
            curl_setopt($ch, CURLOPT_USERPWD, $adapter['username'] . ':' . $adapter['password']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_FTP_SSL, CURLFTPSSL_TRY);
            curl_setopt($ch, CURLOPT_FTPSSLAUTH, CURLFTPAUTH_TLS);
            curl_setopt($ch, CURLOPT_FILETIME, TRUE);
            curl_setopt($ch, CURLOPT_INFILE, $fp);
            curl_exec($ch);
            $error_no = curl_errno($ch);
            curl_close($ch);
            if ($error_no > 0) {
                return array('status' => false, 'message' => 'Connection Failed');
            } else {
                return array('status' => true, 'message' => '');
            }
        } catch (Exception $e) {
            return array('status' => false, 'message' => $e->getMessage());
        }
    }

    public function remove(Request $request) {
        parent::remove($request);
        foreach ($request->ids as $id) {
            User::where('company_id', $id)->delete();
        }
        return array('message' => count($request->ids));
    }

    public function deletePermanently(Request $request) {
        $table = $this->getModel()->getTable();
        $result = $this->getModelNamespace()::whereIn('id', $request->ids)->update(['deleted' => 1]);
        return array('message' => count($request->ids));
    }

    public function revert(Request $request) {
        $restore_all = (string) $request->restore_all;
        $table = $this->getModel()->getTable();
        $counter = 0;
        if ($restore_all == 'false') {
            DB::table($table)->whereIn('id', $request->ids)->update(['deleted_at' => null]);
            foreach ($request->ids as $id) {
                DB::table('users')->whereIn('company_id', $id)->update(['deleted_at' => null]);
            }
            $counter = count($request->ids);
        } else {
            $ids = DB::table($table)->whereNotNull('deleted_at')->get()->pluck('id');
            DB::table($table)->whereIn('id', $ids)->update(['deleted_at' => null]);
            foreach ($request->ids as $id) {
                DB::table('users')->whereIn('company_id', $id)->update(['deleted_at' => null]);
            }
            $counter = count($ids);
        }
        return array('message' => $counter);
    }

}
