<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Country extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['code', 'name', 'currency', 'fips_code', 'iso_numeric', 'north', 'south', 'east', 'west', 'capital', 'continent_name', 'continent', 'languages', 'iso_alpha_3', 'geo_name_id'];
    protected $fillable = ['code', 'name', 'currency', 'fips_code', 'iso_numeric', 'north', 'south', 'east', 'west', 'capital', 'continent_name', 'continent', 'languages', 'iso_alpha_3', 'geo_name_id'];
    public $searchable = ['code', 'name', 'currency', 'fips_code', 'iso_numeric', 'north', 'south', 'east', 'west', 'capital', 'continent_name', 'continent', 'languages', 'iso_alpha_3', 'geo_name_id'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'country';
    public $fields_array = array();
}