<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class Emaillog extends BaseModel {
    
    use SoftDeletes;
    protected static $logAttributes = ['send_by', 'send_to', 'body', 'email_template_id'];
    protected $fillable = ['send_by', 'send_to', 'body', 'email_template_id'];
    public $searchable = ['send_by', 'send_to', 'body', 'email_template_id'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'emaillog';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'send_by' => array(
            'field_name' => 'send_by',
            'db_name' => 'send_by',
            'type' => 'text',
            'placeholder' => 'Send By',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'send_to' => array(
            'field_name' => 'send_to',
            'db_name' => 'send_to',
            'type' => 'text',
            'placeholder' => 'Send To',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'body' => array(
            'field_name' => 'body',
            'db_name' => 'body',
            'type' => 'textarea',
            'placeholder' => 'Body',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
		),
        'email_template_id' => array(
            'field_name' => 'email_template_id',
            'db_name' => 'email_template_id',
            'type' => 'text',
            'placeholder' => 'Email Template',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
		)
    );
}