<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class EmailTemplate extends BaseModel
{

    use SoftDeletes;
    protected $table = "emailtemplates";
    protected static $logAttributes = ['name', 'mail_from', 'mail_subject', 'mail_body', 'sms_subject', 'sms_body'];
    protected $fillable = ['name', 'mail_from', 'mail_subject', 'mail_body', 'sms_subject', 'sms_body'];
    public $searchable = ['name', 'mail_from', 'mail_subject', 'mail_body', 'sms_subject', 'sms_body', 'church_id', 'is_default', 'church_id'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'EmailTemplate';
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'show_in_form' => false,
            'listing' => true,
            'sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'mail_from' => array(
            'field_name' => 'mail_from',
            'db_name' => 'mail_from',
            'type' => 'text',
            'placeholder' => 'Mail From',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'mail_subject' => array(
            'field_name' => 'mail_subject',
            'db_name' => 'mail_subject',
            'type' => 'text',
            'placeholder' => 'Mail Subject',
            'listing' => true,
            'sort' => true,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'mail_body' => array(
            'field_name' => 'mail_body',
            'db_name' => 'mail_body',
            'type' => 'ckeditor',
            'placeholder' => 'Mail Body',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'sms_subject' => array(
            'field_name' => 'sms_subject',
            'db_name' => 'sms_subject',
            'type' => 'text',
            'placeholder' => 'SMS Subject',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'sms_body' => array(
            'field_name' => 'sms_body',
            'db_name' => 'sms_body',
            'type' => 'textarea',
            'placeholder' => 'SMS Body',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '100'
        )
    );

    public function getListQuery(Request $request)
    {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)
            ->select(DB::raw($raw_sql));
        if ($request->user()->can('list-group-users')) { //organisation-admin
            // $query->where('users.company_id', '=', $request->user()->id);
            $churchColl =  DB::table('church_user')->where('user_id', $request->user()->id)->get()->pluck('church_id');
            $church_id = count($churchColl) > 0 ? $churchColl['0'] : "";
            $query->where('is_default', 1);
            $query->where('church_id', $church_id);
        }
        // if ($request->user()->can('delete-all-roles')) { // developer
        //     $query->where('is_default', '!=', 0);
        //     $query->where('church_id', '!=',);
        // }
        if ($request->user()->can('delete-group-roles')) { // superadmin account
            $query->where('is_default', '=', 0);
            $query->where('church_id', '=', 0);
        }
        // exclude developer account

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        if ($trash == 'false') {
            $query->whereNull('deleted_at');
        } else {
            $query->whereNotNull('deleted_at');
        }
        $query->orderBy($sort, $sort_order);
        return $query;
    }
}
