<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use App\Traits\Crud;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Emailtemplate;
use Spatie\Activitylog\LogOptions;

class Requester extends Authenticatable {

    use Notifiable,
        HasApiTokens,
        Crud,
        SoftDeletes,
        LogsActivity,
        HasRoles;

    protected $guard_name = 'api';
    protected $fillable = ['first_name', 'last_name', 'phone', 'avatar', 'email', 'email_verification_token', 'active', 'company_id', 'identity_key', 'deleted_at'];
    protected $hidden = ['password', 'remember_token'];
    protected $casts = ['email_verified_at' => 'datetime'];
    // To prevent storing log of timestamp values
    protected static $logAttributesToIgnore = ['updated_at'];
    // To only store a field that has changed
    protected static $logOnlyDirty = true;
    // Not to store empty log changes as a row
    protected static $submitEmptyLogs = false;
    protected static $logAttributes = ['first_name', 'last_name', 'email', 'phone', 'tour_taken'];
    public $searchable = ['users.first_name', 'users.last_name', 'users.email', 'users.company_id', 'twilio_msg_receives.msg_content', 'twilio_msg_receives.adjective'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'user';
    public $select_fields = ['users.id', 'users.first_name', 'users.last_name', 'users.email', 'users.phone', 'users.active', 'users.attempt', 'twilio_msg_receives.received_from', 'twilio_msg_receives.msg_content', 'twilio_msg_receives.adjective'];
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => false,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'phone' => array(
            'field_name' => 'phone',
            'db_name' => 'phone',
            'type' => 'text',
            'placeholder' => 'Phone',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'msg_content' => array(
            'field_name' => 'msg_content',
            'db_name' => 'msg_content',
            'type' => 'text',
            'placeholder' => 'Message Content',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        )
    );

    public static function boot() {
        parent::boot();
    }

    
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults();
    }

    public function getListQuery(Request $request) {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)
                ->select(DB::raw($raw_sql))
                ->join('twilio_msg_receives', 'users.id', '=', 'twilio_msg_receives.received_from');

        if ($request->user()->roles->first()->id == 18) {
            $la_getUserId = DB::table('users')->select('id')->where('id', $request->user()->id)->orWhere('company_id', $request->user()->id)->get()->toArray();

            $la_getId = array();
            foreach ($la_getUserId as $value) {
                $la_getId[] = $value->id;
            }

            $query->whereIn('twilio_msg_receives.company_id', $la_getId);
        } elseif ($request->user()->roles->first()->id == 19) {
            $query->where('twilio_msg_receives.company_id', $request->user()->id)->orWhere('twilio_msg_receives.company_id', $request->user()->company_id);
        }

        $query->where('twilio_msg_receives.adjective', '!=', NULL);

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        if ($trash == 'false') {
            $query->whereNull('users.deleted_at');
        } else {
            $query->whereNotNull('users.deleted_at');
        }
        $query->orderBy($sort, $sort_order);
        return $query;
    }

    public function getModel($id = null) {
        $model_str = $this->getModelNamespace();
        if ($id) {
            $connection_object = $model_str::find($id);
        } else {
            $connection_object = new $model_str;
        }
        return $connection_object;
    }

}
