<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use App\Traits\Crud;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Emailtemplate;
use App\Models\Bibleverse;
use App\Models\Keyword;
use Illuminate\Contracts\Auth\Guard;

class User extends Authenticatable
{

    use Notifiable,
        HasApiTokens,
        Crud,
        SoftDeletes,
        // LogsActivity,
        HasRoles;

    protected $guard_name = 'api';
    protected $fillable = ['first_name', 'last_name', 'phone', 'avatar', 'email', 'email_verification_token', 'active', 'company_id', 'identity_key', 'deleted_at', 'notification'];
    protected $hidden = ['password', 'remember_token'];
    protected $casts = ['email_verified_at' => 'datetime'];
    // To prevent storing log of timestamp values
    protected static $logAttributesToIgnore = ['updated_at'];
    // To only store a field that has changed
    protected static $logOnlyDirty = true;
    // Not to store empty log changes as a row
    protected static $submitEmptyLogs = false;
    protected static $logAttributes = ['first_name', 'last_name', 'email', 'phone', 'tour_taken'];
    public $searchable = ['users.first_name', 'users.last_name', 'users.email', 'users.company_id'];
    public $default_sort = 'id';
    public $default_sort_order = 'desc';
    public $model = 'user';
    public $select_fields = ['users.id', 'users.first_name', 'users.last_name', 'users.email', 'users.phone', 'users.active', 'users.notification', 'users.attempt', 'users.company_id', 'roles.name as roles', 'churches.church_name as church_id'];
    //public $companies = array();
    public $fields_array = array(
        'id' => array(
            'field_name' => 'id',
            'db_name' => 'id',
            'type' => 'text',
            'placeholder' => 'Id',
            'listing' => true,
            'show_in_form' => false,
            'sort' => true,
            'default_sort' => true,
            'required' => false,
            'value' => '',
            'width' => '50'
        ),
        'first_name' => array(
            'field_name' => 'first_name',
            'db_name' => 'first_name',
            'type' => 'text',
            'placeholder' => 'First Name',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'last_name' => array(
            'field_name' => 'last_name',
            'db_name' => 'last_name',
            'type' => 'text',
            'placeholder' => 'Last Name',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'email' => array(
            'field_name' => 'email',
            'db_name' => 'email',
            'type' => 'text',
            'placeholder' => 'Email',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'phone' => array(
            'field_name' => 'phone',
            'db_name' => 'phone',
            'type' => 'text',
            'placeholder' => 'Phone',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'roles' => array(
            'field_name' => 'roles',
            'db_name' => 'roles',
            'type' => 'select',
            'placeholder' => 'Role',
            'options' => [],
            'listing' => true,
            'required' => false,
            'value' => '',
            'width' => '50',
            'default_sort' => false,
            'show_in_form' => false
        ),
        'avatar' => array(
            'field_name' => 'avatar',
            'db_name' => 'avatar',
            'type' => 'file',
            'placeholder' => 'Avatar',
            'listing' => false,
            'sort' => true,
            'default_sort' => false,
            'required' => false,
            'value' => '',
            'accept' => 'image/*',
            'accept_type' => 'jpg|jpeg|png|gif',
            'width' => '50'
        ),
        'church_id' => array(
            'field_name' => 'church_id',
            'db_name' => 'church_id',
            'type' => 'select',
            'placeholder' => 'Church',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => '',
            'width' => '50'
        ),
        'active' => array(
            'field_name' => 'active',
            'db_name' => 'active',
            'type' => 'switch',
            'placeholder' => 'Active',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => 1,
            'width' => '50'
        ),
        'notification' => array(
            'field_name' => 'notification',
            'db_name' => 'notification',
            'type' => 'switch',
            'placeholder' => 'Notification',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'value' => 0,
            'width' => '50'
        ),
        'attempt' => array(
            'field_name' => 'attempt',
            'db_name' => 'attempt',
            'type' => 'switch',
            'placeholder' => 'Locked',
            'listing' => true,
            'sort' => true,
            'default_sort' => false,
            'required' => true,
            'show_in_form' => false,
            'value' => '',
            'width' => '50'
        )

    );

    public function churches()
    {
        return $this->hasMany(Church::class);
    }

    function __construct($arguments = array())
    {
        parent::__construct($arguments);
        $this->fields_array['church_id']['options'] = $this->getChurches();
    }

    // $user->roles()->sync([1, 2, 3]);
    /**
     * Boot Functions
     */
    public static function boot()
    {
        parent::boot();
        self::created(function ($model) {
            if ($model->email != trim($model->phone, "+") . '@requester.req') :

                $emailtemplate = Emailtemplate::where('name', 'new_user_verification')->first();
                //dd($emailtemplate);
                $email_template_id = $emailtemplate ? $emailtemplate->id : 0;
                $body = $emailtemplate ? $emailtemplate->mail_body : '';
                $subject = $emailtemplate ? $emailtemplate->mail_subject : '';
                $url = url('/users/verify') . '?token=' . $model->email_verification_token;
                // $url = "<a href='$url'>click here</a>";
                $body = str_replace("{{user_verfication_link}}", $url, $body);
                // mail('lal.yadav@codeclouds.in', 'TEST', 'TEST MESSAGE');
                $mail = new \App\Http\Helpers\SendEmail;
                try {
                    $mail->send($model->email, env('MAIL_FROM_ID'), $body, $subject, $email_template_id, null);
                    //$mail->send($model->email, env('MAIL_FROM_ID'), $body, $subject, null);
                } catch (\Exception $e) {
                    return $e->getMessage();
                }
                return 'true';
            endif;
        });
    }

    public function FnCloneDefaultEmailTemplates($request_id)
    {
        $default_email_templates = Emailtemplate::where('is_default', 0)->get();
        foreach ($default_email_templates as $single_template) :
            DB::table('emailtemplates')->insert(
                ['name' => $single_template->name, 'mail_from' =>  $single_template->mail_from, 'mail_subject' => $single_template->mail_subject, 'mail_body' => $single_template->mail_body, 'sms_subject' => $single_template->sms_subject, 'sms_body' => $single_template->sms_body, 'is_default' => 1, 'user_id' => $request_id]
            );
        endforeach;
        return 1;
    }

    public function FnCloneDefaultBibleVerses($request_id)
    {
        $default_email_templates = Bibleverse::where('is_default', 0)->get();
        foreach ($default_email_templates as $single_template) :
            DB::table('bibleverses')->insert(
                ['verse' => $single_template->verse, 'is_default' => 1, 'user_id' => $request_id]
            );
        endforeach;
        return 1;
    }

    //upload image user
    public function addImage(Request $request, $id)
    {
        if ($request->file('avatar')) {
            $user_image = $request->file('avatar');
            $user_image = $id . '_' . time() . '_user_image_' . $user_image->getClientOriginalExtension();
            $user_image->storeAs('uploads/users', $user_image);
        }
    }

    public function getAvatarAttribute($value)
    {
        if (is_null($value))
            return asset('/uploads/users/default_user.png');
        elseif (file_exists(public_path("/uploads/users/{$value}")))
            return asset('/uploads/users/' . $value);
        else
            return $value;
    }

    // Mutator function
    public function setEmailVerificationTokenAttribute($value)
    {
        $this->attributes['email_verification_token'] = base64_encode($this->attributes['email']);
    }

    public function view(Request $request)
    {
        $user = self::find($request->id);
        $user->getRoleNames();
        $roles = Role::where('deleted_at', null)->get();

        if ($request->user()->company_id != 2) {
            $roles = Role::whereNotIn('id', [7, 5])->where('deleted_at', null)->get();
        } else { // developer user
            $roles = Role::where('deleted_at', null)->get();
        }
        $keyword = "";
        $church_id = "";
        if ($user->id > 0) :
            $keywordColl = Keyword::where('user_id', $user->id)->where('deleted_at', null)->get()->pluck('organisation_code');
            $keyword = count($keywordColl) > 0 ? $keywordColl['0'] : "";
            $churchColl =  DB::table('church_user')->where('user_id', $user->id)->get()->pluck('church_id');
            $church_id = count($churchColl) > 0 ? $churchColl['0'] : "";
        endif;
        $user->keyword = $keyword;
        $user->church_id = $church_id;
        return array('result' => $user, 'roles' => $roles);
    }

    public function getChurches()
    {
        $church_arr = array();
        // $churches = \App\Models\Church::where('user_id', $request->user()->id)->get();
        $churches = \App\Models\Church::All();
        foreach ($churches as $church) {
            $church_arr[$church->id] = $church->church_name;
        }
        return $church_arr;
    }
    public function fetchChurchesIds()
    {
        $church_arr = array();
        // $churches = \App\Models\Church::where('user_id', $request->user()->id)->get();
        $churches = \App\Models\Church::All();
        foreach ($churches as $church) {
            $church_arr[$church->id] = $church->church_name;
        }
        return $church_arr;
    }



    public function revise(Request $request, $id)
    {

        $resource = $this->getModel($request->id);
        $fillable_columns = $resource->getFillable();
        if ($resource) {
            foreach ($fillable_columns as $column) {
                if (!is_null($request->$column)) {
                    $resource->$column = trim($request->$column);
                }
            }
            $la_getUser = \App\Models\User::where('email', $request->email)->where('id', '!=', $request->id)->get()->toArray();
            if (count($la_getUser) != 0) {
                return [
                    'status' => false,
                    'message' => 'Email address already exists!'
                ];
            }
            $resource->notification = ($resource->notification) ? 1 : 0;
            if (!$resource->save()) {
                print_r($resource->errors()->all());
                die;
                return false;
            } else {

                // add data to the pivot table
                if ($request->church_id) :
                    DB::table('church_user')->where('user_id', $request->id)->delete();
                    if (!empty($request->church_id)) :
                        DB::table('church_user')->insert(
                            ['user_id' => $resource->id, 'church_id' =>  $request->church_id]
                        );
                    endif;
                endif;

                return array('message' => 'success', 'id' => $resource->id);
            }
        }
    }

    public function getListQuery(Request $request)
    {
        $sort = $request->sort ? $request->sort : $this->getModel()->default_sort;
        $sort_order = $request->sort_order ? $request->sort_order : $this->getModel()->default_sort_order;
        $trash = isset($request->trash) ? $request->trash : 'false';
        $table = $this->getModel()->getTable();
        $raw_sql = "$table.*";
        if (!empty($this->select_fields)) {
            $raw_sql = implode(',', $this->select_fields);
        }
        $query = DB::table($table)
            ->select(DB::raw($raw_sql))
            ->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')
            ->leftJoin('roles', 'roles.id', '=', 'model_has_roles.role_id')
            ->leftJoin('church_user', 'church_user.user_id', '=', 'users.id')
            ->leftJoin('churches', 'churches.id', '=', 'church_user.church_id');
        if ($request->user()->can('list-group-users')) { //organisation-admin
            // $query->where('users.company_id', '=', $request->user()->id);
            $churchColl =  DB::table('church_user')->where('user_id', $request->user()->id)->get()->pluck('church_id');
            $church_id = count($churchColl) > 0 ? $churchColl['0'] : "";
            $query->where('church_user.church_id', '=', $church_id);
            $query->where('model_has_roles.role_id', '=', 19);
        }
        if ($request->user()->can('delete-all-roles')) { // developer
            $query->where('model_has_roles.role_id', '!=', 21);
        }
        if ($request->user()->can('delete-group-roles')) { // superadmin account
            $query->whereIn('model_has_roles.role_id', [18]);
        }
        // exclude developer account

        // Filter records using where clause
        $where_clause = $request->where_clause ? $request->where_clause : '';
        if ($where_clause != '') {
            $where_clause = json_decode($where_clause, 1);
            $where_fields = $where_clause['where_fields'];
            $where_values = $where_clause['where_values'];
            foreach ($where_fields as $key => $where_field) {
                if (is_array($where_values[$key])) {
                    $query->whereIn($where_field, $where_values[$key]);
                } else {
                    $query->where($where_field, $where_values[$key]);
                }
            }
        }

        if (!empty($this->searchable) && $request->search != '') {
            $concat_fields = 'concat(';
            foreach ($this->searchable as $field) {
                $concat_fields .= 'COALESCE(' . $field . ", ''),'',";
            }
            $concat_fields = rtrim($concat_fields, ",'',");
            $concat_fields .= ')';
            $query->where([[DB::raw($concat_fields), 'like', "%$request->search%"]]);
        }
        if ($trash == 'false') {
            $query->whereNull('users.deleted_at');
        } else {
            $query->whereNotNull('users.deleted_at');
        }
        $query->orderBy($sort, $sort_order);
        return $query;
    }

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

    public function getModel($id = null)
    {
        $model_str = $this->getModelNamespace();
        if ($id) {
            $connection_object = $model_str::find($id);
        } else {
            $connection_object = new $model_str;
        }
        return $connection_object;
    }

    public function fetchDropdownOptions(Request $request)
    {
        $result_array = array();
        $search = $request->search;
        $column = $request->column;
        //        $results = $this->getModel()::where($column, 'like', "%$search%")->whereNull('deleted_at')->get();
        $results = $this->getModel()::where('first_name', 'like', "%$search%")
            ->orWhere('last_name', 'like', "%$search%")->whereNull('deleted_at')->get();
        foreach ($results as $result) {
            if (($request->user()->roles->first()->id == 17) && ($result->company_id == $request->user()->id)) {
                array_push($result_array, array('index' => $result->id, 'value' => $result->first_name . ' ' . $result->last_name));
            } elseif (($request->user()->roles->first()->id == 18) && (($result->company_id == $request->user()->id) || ($result->id == $request->user()->id))) {
                array_push($result_array, array('index' => $result->id, 'value' => $result->first_name . ' ' . $result->last_name));
            } elseif (($request->user()->roles->first()->id == 19) && ($result->id == $request->user()->id)) {
                array_push($result_array, array('index' => $result->id, 'value' => $result->first_name . ' ' . $result->last_name));
            }
        }
        return $result_array;
    }
}
