<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\DynamicRouteController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\Controller;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'auth'], function () {
    Route::post('login', [AuthController::class, 'login']);
    Route::post('signup', [AuthController::class, 'signup']);
    Route::post('forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('set-password', [AuthController::class, 'setPassword']);
    Route::group(['middleware' => 'auth:api'], function () {
        Route::get('logout', [AuthController::class, 'logout']);
        Route::get('profile', [AuthController::class, 'profile']);
        Route::post('update-profile', [AuthController::class, 'updateProfile']);
        Route::get('remove-avatar', [UsersController::class, 'removeAvatar']);
        Route::post('change-password', [AuthController::class, 'changePassword']);
    });
});

Route::post('webform', [Controller::class, 'webform']);
Route::post('fetch-inbound-sms', [Controller::class, 'fetchInboundSms']);
Route::get('user/groups', [UsersController::class, 'groups']);
Route::get('user/getmessages', [UsersController::class, 'getmessages']);
Route::get('user/savemessage', [UsersController::class, 'savemessage']);
Route::group(['middleware' => 'auth:api'], function () {
    Route::post('permission/generate', [PermissionsController::class, 'generate']);

    Route::group(['middleware' => 'check_permission'], function () {
        Route::get('{ctrl}/{func?}/{id?}', [DynamicRouteController::class, 'handle']);
        Route::post('{ctrl}/{func?}/{id?}', [DynamicRouteController::class, 'handle']);
    });
});
